<?php if ( !defined('ABSPATH') ) die('No direct access');
class oplSidebarOptin extends WP_Widget {
	function oplSidebarOptin() {
		$instance = array('description' => 'Drag this widget to display an optin form in your blog sidebar.' );
		parent::WP_Widget(false, 'InstaBuilder - Sidebar Optin', $instance);      
	}

	function widget($args, $instance) {
		extract($args);
		
		$title       = ( opl_isset($instance['title']) != '' ) ? stripslashes(esc_attr($instance['title'])) : 'Get FREE Stuff Now!';
		$resp        = opl_isset(stripslashes($instance['resp']));
		$instruction = ( opl_isset($instance['instruction_txt']) != '' ) ? stripslashes(esc_attr($instance['instruction_txt'])) : 'Enter your name and email below to GET INSTANT ACCESS!';
		$name_label  = ( opl_isset($instance['name_label']) != '' ) ? stripslashes(esc_attr($instance['name_label'])) : '** Your name here';
		$email_label = ( opl_isset($instance['email_label']) != '' ) ? stripslashes(esc_attr($instance['email_label'])) : '** Your email here';
		$btn_color   = opl_isset(stripslashes(esc_attr($instance['btn_color'])));
		$btn_label   = ( opl_isset($instance['btn_label']) != '' ) ? stripslashes(esc_attr($instance['btn_label'])) : 'Subscribe Now';
		$privacy     = ( opl_isset($instance['privacy']) != '' ) ? stripslashes(esc_attr($instance['privacy'])) : 'Your privacy is SAFE';

		$fb_text = opl_isset(esc_attr(stripslashes($instance['fb_text'])));
		$fb_label = opl_isset(esc_attr(stripslashes($instance['fb_label'])));
		$fb_msg = opl_isset(wptexturize(esc_attr(stripslashes($instance['fb_msg']))));
		
		$manual = opl_isset($instance['is_manual']);
		$fb_connect = opl_isset($instance['is_facebook']);
		$fb_post = opl_isset($instance['is_autopost']);
		
		if ( wp_get_theme() != 'Americana Mojave' ) echo $before_widget;

		echo '<div class="opl-sidebar-optin">';
		echo '<h2 class="opl-sidebar-optin-title">' . $title . '</h2>';
		if ( $instruction != '' ) echo '<p>' . $instruction . '</p>';

		$form = opl_extract_fields( $resp, $name_label, $email_label );
		
		echo '<form method="post" id="opl-widget-submit_' . $widget_id . '" class="opl-resp-submit" action="' . opl_isset($form['action']) . '" style="margin:0 !important;padding:0 !important; height: auto !important; float:none !important; background-color:transparent !important;">' . "\n";
		if ( isset($form['fields']) && is_array($form['fields']) && count($form['fields']) > 0 ) {
			foreach ( $form['fields'] as $k => $v ) {
				$field_id = ( stristr( $k, 'mail') || stristr( $k, 'from') ) ? 'opl_email' : 'opl_name';
				$field_class = ( stristr( $k, 'mail') || stristr( $k, 'from') ) ? 'opl-email' : 'opl-name opl-required';
				
				if ( $manual != 1 && $fb_connect == 1 )
					echo '<input type="hidden" name="' . $k . '" value="' . stripslashes($v) . '" id="' . $field_id . '" class="' . $field_class . '" />' . "\n";
				else
					echo '<input type="text" name="' . $k . '" value="" id="' . $field_id . '" class="opl-widget-field ' . $field_class . '" placeholder="' . stripslashes($v) . '" /><span></span>' . "\n";
			}
		}
		
		if ( isset($form['hiddens']) && is_array($form['hiddens']) && count($form['hiddens']) > 0 ) {
			foreach ( $form['hiddens'] as $k => $v ) {
				echo '<input type="hidden" name="' . $k . '" value="' . $v . '" />' . "\n";
			}
		}
		
		if ( $manual == 1 )
			echo '<a href="#" id="opl-widget-btn_' . $widget_id . '" class="opl-btn btn-' . $btn_color . '"><span>' . $btn_label . '</span></a>';
		echo '</form>' . "\n";
		
		if ( $fb_connect == 1 ) :
			echo '<div id="opl-widget-fb-connect" style="margin:10px 0; text-align:center">';
			if ( $fb_text != '' )
				echo '<p class="optin_fb_text"><strong>' . $fb_text . '</strong></p>';
				
			echo '<button class="opl-facebook-btn opl-wgt-connect" name="opl-connect">' . $fb_label . '</button>';
			echo '<input type="hidden" class="opl-widget-fb-autopost" value="' . $fb_post . '">';
			echo '<input type="hidden" class="opl-widget-fb-msg" value="' . str_replace(array("\r", "\n", "\r\n"), '', $fb_msg) . '">';
			echo '</div>';
		endif;
					
		echo '<p><small>' . $privacy . '</small></p>' . "\n";
		
		
		echo '</div>';
		echo '
		<script type="text/javascript">
		jQuery(document).ready(function(){
			jQuery("#opl-widget-btn_' . $widget_id . '").click(function(e){
				var $this = $(this), reqpass = 0;
				$this.parent().find(".opl-required").each(function(){
					if ( $(this).is(":visible") ) {
						if ( !insta_required_validation($(this)) ) reqpass += 1;
					}
				});
				
				if ( $this.parent().find(".opl-email").length || $this.parent().find(".opl-email").is(":visible") )
				if ( !insta_email_validation($this.parent().find(".opl-email")) ) reqpass += 1;
				
				if ( reqpass <= 0 ) {
					document.getElementById("opl-widget-submit_' . $widget_id . '").submit();
				}
				e.preventDefault();
			});
		});
		</script>
		';
		if ( wp_get_theme() != 'Americana Mojave' ) echo $after_widget;
	}

	function update($new_instance, $old_instance) {
		$new_instance['is_manual'] = ( isset($new_instance['is_manual']) ) ? 1 : 0;
		$new_instance['is_facebook'] = ( isset($new_instance['is_facebook']) ) ? 1 : 0;
		$new_instance['is_autopost'] = ( isset($new_instance['is_autopost']) ) ? 1 : 0;
		return $new_instance;
	}

	function form( $instance ) {
		$title       = ( opl_isset($instance['title']) != '' ) ? stripslashes($instance['title']) : 'Get FREE Stuff Now!';
		$resp        = opl_isset(stripslashes($instance['resp']));
		$instruction = ( opl_isset($instance['instruction_txt']) != '' ) ? stripslashes( $instance['instruction_txt'] ) : 'Enter your name and email below to GET INSTANT ACCESS!';
		$name_label  = ( opl_isset($instance['name_label']) != '' ) ? stripslashes( $instance['name_label'] ) : '** Your name here';
		$email_label = ( opl_isset($instance['email_label']) != '' ) ? stripslashes( $instance['email_label'] ) : '** Your email here';
		$btn_color   = opl_isset(strip_tags(stripslashes($instance['btn_color'])));
		$btn_label   = ( opl_isset($instance['btn_label']) != '' ) ? stripslashes(strip_tags($instance['btn_label'])) : 'Subscribe Now';
		$privacy     = ( opl_isset($instance['privacy']) != '' ) ? strip_tags(stripslashes($instance['privacy'])) : 'Your privacy is SAFE';

		$fb_text = opl_isset(strip_tags(stripslashes($instance['fb_text'])));
		$fb_label = ( opl_isset($instance['fb_label']) != '' ) ? strip_tags(stripslashes($instance['fb_label'])) : 'Subscribe with Facebook';
		$fb_msg = opl_isset(strip_tags(stripslashes($instance['fb_msg'])));
		
		$checked = ( isset($instance['is_manual']) && $instance['is_manual'] == 1 ) ? ' checked="checked"' : '';
		$checked2 = ( !isset($instance['is_manual']) ) ? ' checked="checked"' : '';
		$fb_checked = ( opl_isset($instance['is_facebook']) == 1 ) ? ' checked="checked"' : '';
		$fb_checked2 = ( opl_isset($instance['is_autopost']) == 1 ) ? ' checked="checked"' : '';
		
		echo '
		<div id="opl-wgt-form">
		<p>
            	<label for="' . $this->get_field_id('title') . '">Title:</label>
            	<input type="text" name="' . $this->get_field_name('title') . '" value="' . $title . '" class="widefat" id="' . $this->get_field_id('title') . '" />
        </p>
		<p>
            	<label for="' . $this->get_field_id('resp') . '">Autoresponder Code:</label>
            	<textarea name="' . $this->get_field_name('resp') . '" class="widefat" id="' . $this->get_field_id('resp') . '">' . $resp . '</textarea>
        </p>
		<p>
            	<label for="' . $this->get_field_id('instruction_txt') . '">Subscribe Instruction:</label>
            	<textarea name="' . $this->get_field_name('instruction_txt') . '" class="widefat" id="' . $this->get_field_id('instruction_txt') . '">' . $instruction . '</textarea>
        </p>

		<p><input class="wgt-manual-form" id="' . $this->get_field_id('is_manual') . '" name="' . $this->get_field_name('is_manual') . '" type="checkbox" value="1" ' . $checked . $checked2 . '/>&nbsp;<label for="' . $this->get_field_id('is_manual') . '">' . __('Enable Manual Submission') . '</label></p>
		
		<div class="widget-manual">
		<p>
            	<label for="' . $this->get_field_id('name_label') . '">Name Field Label:</label>
            	<input type="text" name="' . $this->get_field_name('name_label') . '" value="' . $name_label . '" class="widefat" id="' . $this->get_field_id('name_label') . '" />
        	</p>

		<p>
            	<label for="' . $this->get_field_id('email_label') . '">Email Field Label:</label>
            	<input type="text" name="' . $this->get_field_name('email_label') . '" value="' . $email_label . '" class="widefat" id="' . $this->get_field_id('email_label') . '" />
        	</p>

		<p>
            	<label for="' . $this->get_field_id('btn_color') . '">Button Color:</label>
            	<select name="' . $this->get_field_name('btn_color') . '" id="' . $this->get_field_id('btn_color') . '" class="widefat">
		';

		$colors = array('yellow' => 'Yellow', 'orange' => 'Orange', 'green' => 'Green', 'blue' => 'Blue', 'grey' => 'Grey', 'red' => 'Red' );
		foreach ( $colors as $color => $option ) {
			$selected = ( $btn_color == $color ) ? ' selected="selected"' : '';
			echo '<option value="' . $color . '"' . $selected . '>' . $option . '</option>';
		}
		
		echo '
		</select>
        </p>
		<p>
        	<label for="' . $this->get_field_id('btn_label') . '">Button Label:</label>
        	<input type="text" name="' . $this->get_field_name('btn_label') . '" value="' . $btn_label . '" class="widefat" id="' . $this->get_field_id('btn_label') . '" />
        </p>
		</div>
        	
		<p><input class="wgt-fb-form" id="' . $this->get_field_id('is_facebook') . '" name="' . $this->get_field_name('is_facebook') . '" type="checkbox" value="1" ' . $fb_checked . '/>&nbsp;<label for="' . $this->get_field_id('is_facebook') . '">Enable Facebook Connect</label></p>
		
		<div class="widget-facebook">
		<p>
            	<label for="' . $this->get_field_id('fb_text') . '">Facebook Connect Text (optional):</label>
            	<input type="text" name="' . $this->get_field_name('fb_text') . '" value="' . $fb_text . '" class="widefat" id="' . $this->get_field_id('fb_text') . '" />
        </p>
		<p>
            	<label for="' . $this->get_field_id('fb_label') . '">Facebook Button Label:</label>
            	<input type="text" name="' . $this->get_field_name('fb_label') . '" value="' . $fb_label . '" class="widefat" id="' . $this->get_field_id('fb_label') . '" />
        </p>
        
        <p><input class="wgt-fbm-form" id="' . $this->get_field_id('is_autopost') . '" name="' . $this->get_field_name('is_autopost') . '" type="checkbox" value="1" ' . $fb_checked2 . '/>&nbsp;<label for="' . $this->get_field_id('is_autopost') . '">Auto-Post to Facebook Wall</label></p>
        <p>
            	<label for="' . $this->get_field_id('fb_msg') . '">Facebook Wall Message:</label>
            	<textarea name="' . $this->get_field_name('fb_msg') . '" class="widefat" id="' . $this->get_field_id('fb_msg') . '">' . $fb_msg . '</textarea>
        </p>
        </div>
        
		<p>
        	<label for="' . $this->get_field_id('privacy') . '">Privacy Notice:</label>
        	<textarea name="' . $this->get_field_name('privacy') . '" class="widefat" id="' . $this->get_field_id('privacy') . '">' . $privacy . '</textarea>
        </p>
        </div>
		';
	}
}

class oplCountdownWidget extends WP_Widget {
	function oplCountdownWidget() {
		$instance = array('description' => 'Drag this widget to display a countdown timer on your blog sidebar.' );
		parent::WP_Widget(false, 'InstaBuilder - Countdown Widget', $instance);      
	}

	function widget($args, $instance) {
		extract($args);
		
		$before_txt = opl_isset(stripslashes($instance['before_txt']));
		$after_txt = opl_isset(stripslashes($instance['after_txt']));
		$day = opl_isset(esc_attr(stripslashes($instance['day'])));
		$month = opl_isset(esc_attr(stripslashes($instance['month'])));
		$year = opl_isset(esc_attr(stripslashes($instance['year'])));
		$hour = opl_isset(esc_attr(stripslashes($instance['hour'])));
		$min = opl_isset(esc_attr(stripslashes($instance['min'])));
		$sec = opl_isset(esc_attr(stripslashes($instance['sec'])));
		$timezone = opl_isset(esc_attr(stripslashes($instance['tz'])));
		$style = opl_isset(esc_attr(stripslashes($instance['style'])));
		$redirect = opl_isset(strip_tags(stripslashes($instance['redirect'])));
		
		global $opl_cd;
		
		// wp_enqueue_script('ib-countdown', OPL_URL . 'js/countdown/jquery.ibCountdown.js', array('jquery'));
		$pattern = "/\b(?:(?:https?|ftp):\/\/|www\.)[-a-z0-9+&@#\/%?=~_|!:,.;]*[-a-z0-9+&@#\/%=~_|]/i";
		$comma = ( preg_match($pattern, $redirect) ) ? ',' : ''; 
		$script = ( preg_match($pattern, $redirect) ) ? 'onComplete: function(){ window.location = "' . $redirect . '"; }' : '';
		
		if ( empty($timezone) || !is_numeric($timezone) ) {
			$gmtDate = new DateTime('now', new DateTimeZone('UTC'));
			$gmtTime = $gmtDate->format('H:i:s');
			$gmt = strtotime($gmtTime);
			
			$wp_time = get_option('timezone_string');
			$tz = ( !empty($wp_time) ) ? $wp_time : date_default_timezone_get();
			$localDate = new DateTime('now', new DateTimeZone($tz));
			$localTime = $localDate->format('H:i:s');
			$local = strtotime($localTime);	
			$offset = $local - $gmt;
			$timezone = @($offset/60/60);
		}
		
		$countdown = '';
		$countdown .= '
			<!-- Countdown start -->
			<div id="opl_countdown_' . $opl_cd . '" class="opl-widget-countdown opl-widget-countdown-' . $style . '">
				<div class="opl-dash weeks_dash">
					<span class="dash_title">weeks</span>
					<div class="digit">0</div>
					<div class="digit">0</div>
					<div class="ibclearfix"></div>
				</div>
				<div class="opl-dash days_dash">
					<span class="dash_title">days</span>
					<div class="digit">0</div>
					<div class="digit">0</div>
					<div class="ibclearfix"></div>
				</div>
				<div class="opl-dash hours_dash">
					<span class="dash_title">hours</span>
					<div class="digit">0</div>
					<div class="digit">0</div>
					<div class="ibclearfix"></div>
				</div>
				<div class="opl-dash minutes_dash">
					<span class="dash_title">minutes</span>
					<div class="digit">0</div>
					<div class="digit">0</div>
					<div class="ibclearfix"></div>
				</div>
				<div class="opl-dash seconds_dash">
					<span class="dash_title">seconds</span>
					<div class="digit">0</div>
					<div class="digit">0</div>
					<div class="ibclearfix"></div>
				</div>
				<div class="ibclearfix"></div>
			</div>
			<div class="ibclearfix"></div>
			<!-- Countdown end -->
			
			<script type="text/javascript">
				(function($){
					jQuery(\'#opl_countdown_' . $opl_cd . '\').ibCountdown({
							\'day\': ' . $day . ',
							\'month\': ' . $month . ',
							\'year\': ' . $year . ',
							\'hour\': ' . $hour . ',
							\'min\': ' . $min . ',
							\'sec\': ' . $sec . ',
							\'width\': 60,
							\'offset\': ' . $timezone . '' . $comma . '
						' . $script . '
					});
				})(jQuery);
			</script>
		';
		
		$title = apply_filters('widget_title', empty($instance['title']) ? '&nbsp;' : $instance['title'], $instance, $this->id_base);
		
		if ( wp_get_theme() != 'Americana Mojave' ) echo $before_widget;
		if ( $title )
			echo $before_title . $title . $after_title;
		
		if ( !empty($before_txt) ) echo '<div class="textwidget">' . $before_txt . '</div>';
		echo $countdown;
		if ( !empty($after_txt) ) echo '<div class="textwidget">' . $after_txt . '</div>';
		if ( wp_get_theme() != 'Americana Mojave' ) echo $after_widget;
	
		$opl_cd++;
	}
	
	function update($new_instance, $old_instance) {                
		return $new_instance;
	}
	
	function form($instance) {
		$title = opl_isset(trim(strip_tags(stripslashes($instance['title']))));
		$before_txt = opl_isset(trim(stripslashes($instance['before_txt'])));
		$after_txt = opl_isset(trim(stripslashes($instance['after_txt'])));
		$day = ( opl_isset($instance['day']) != '' ) ? strip_tags(stripslashes($instance['day'])) : date("d", strtotime('+7 day'));
		$month = ( opl_isset($instance['month']) != '' ) ? strip_tags(stripslashes($instance['month'])) : date("m", strtotime('+7 day'));
		$year = ( opl_isset($instance['year']) != '' ) ? strip_tags(stripslashes($instance['year'])) : date("Y", strtotime('+7 day'));
		$hour = ( opl_isset($instance['hour']) != '' ) ? strip_tags(stripslashes($instance['hour'])) : '11';
		$min = ( opl_isset($instance['min']) != '' ) ? strip_tags(stripslashes($instance['min'])) : '00';
		$sec = ( opl_isset($instance['sec']) != '' ) ? strip_tags(stripslashes($instance['sec'])) : '00';
		$tz = opl_isset(trim(strip_tags(stripslashes($instance['tz']))));
		$style = opl_isset(trim(strip_tags(stripslashes($instance['style']))));
		$redirect = opl_isset(trim(strip_tags(stripslashes($instance['redirect']))));
		
		$styles = array("dark", "light", "red");
		
		echo '
		<p>
            	<label for="' . $this->get_field_id('title') . '">Title:</label>
            	<input type="text" name="' . $this->get_field_name('title') . '" value="' . $title . '" class="widefat" id="' . $this->get_field_id('title') . '" />
        </p>
        
		<p><label for="' . $this->get_field_id('style') . '">Countdown Style:</label>
			<select name="' . $this->get_field_name('style') . '" id="' . $this->get_field_id('style') . '" class="widefat">
			
		';
				foreach ( $styles as $s ) {
					$selected = ( $s == $style ) ? ' selected="selected"' : '';
					echo '<option value="' . $s . '"' . $selected . '>' . ucwords($s) . '</option>';
				}
		
		echo '
			</select>
		</p>
		
        <p>
            	<label>Target Date (DD-MM-YYYY):</label><br />
            	<input type="text" name="' . $this->get_field_name('day') . '" value="' . $day . '" id="' . $this->get_field_id('day') . '" style="width:30px" /> -
            	<input type="text" name="' . $this->get_field_name('month') . '" value="' . $month . '" id="' . $this->get_field_id('month') . '" style="width:30px" /> -
            	<input type="text" name="' . $this->get_field_name('year') . '" value="' . $year . '" id="' . $this->get_field_id('year') . '" style="width:50px" />
        </p>
        
		<p>
            	<label>Target Time (hour:min:sec):</label><br />
            	<input type="text" name="' . $this->get_field_name('hour') . '" value="' . $hour . '" id="' . $this->get_field_id('hour') . '" style="width:30px" /> :
            	<input type="text" name="' . $this->get_field_name('min') . '" value="' . $min . '" id="' . $this->get_field_id('min') . '" style="width:30px" /> :
            	<input type="text" name="' . $this->get_field_name('sec') . '" value="' . $sec . '" id="' . $this->get_field_id('sec') . '" style="width:30px" />
        		<br />
				<small>' . __( 'Note: Must be in 24 hours format.' ) . '</small>
        </p>
		
		<p><label for="' . $this->get_field_id('tz') . '">Timezone Offset:</label>
			<select name="' . $this->get_field_name('tz') . '" id="' . $this->get_field_id('tz') . '" class="widefat">
		';
		if ( $timezone = opl_timezone_list() ) {
			foreach ( $timezone as $k => $v ) {
				$selected = ( str_replace('UTC', '', $k) == $tz ) ? ' selected="selected"' : '';
				$utc = ( empty($tz) && $k == 'UTC' ) ? ' selected="selected"' : '';
				echo '<option value="' . str_replace('UTC', '', $k) . '"' . $selected . $utc . '>' . $v . '</option>';
			}
		}
		echo '
			</select>
		</p>
		
		<p>
            	<label for="' . $this->get_field_id('before_txt') . '">Before Countdown Text (optional):</label>
            	<textarea name="' . $this->get_field_name('before_txt') . '" class="widefat" id="' . $this->get_field_id('before_txt') . '">' . $before_txt . '</textarea>
        		<br />
				<small>' . __( 'You can enter any text above the countdown timer. HTML is allowed.' ) . '</small>
        </p>
		
		<p>
            	<label for="' . $this->get_field_id('after_txt') . '">After Countdown Text (optional):</label>
            	<textarea name="' . $this->get_field_name('after_txt') . '" class="widefat" id="' . $this->get_field_id('after_txt') . '">' . $after_txt . '</textarea>
        		<br />
				<small>' . __( 'You can enter any text below the countdown timer. HTML is allowed.' ) . '</small>
        </p>
        <p>
            	<label for="' . $this->get_field_id('redirect') . '">Redirect URL (optional):</label>
            	<input type="text" name="' . $this->get_field_name('redirect') . '" value="' . $redirect . '" class="widefat" id="' . $this->get_field_id('redirect') . '" />
            	<br />
				<small>' . __( 'You can redirect the visitors to any URL once the countdown stop. Leave this blank if you don\'t want to redirect.' ) . '</small>
        </p>
		';
	}
}

class oplViralWidget extends WP_Widget {
	function oplViralWidget() {
		$instance = array('description' => 'Drag this widget to display the viral download lock on your blog sidebar.');
		parent::WP_Widget(false, 'InstaBuilder - Viral Download Lock', $instance);
	}
	
	function widget($args, $instance) {
		extract($args);
		
		$title = opl_isset(trim(strip_tags(stripslashes($instance['title']))));
		$text = opl_isset(stripslashes($instance['text']));
		$btn_color = opl_isset(trim(esc_attr(stripslashes($instance['btn_color']))));
		$btn_label = opl_isset(trim(esc_attr(stripslashes($instance['btn_label']))));
		$dl_url = opl_isset(trim(esc_attr(stripslashes($instance['dl_url']))));
		$share_url = opl_isset(trim(esc_attr(stripslashes($instance['share_url']))));
		$fbs_title = opl_isset(trim(strip_tags(stripslashes($instance['fbs_title']))));
		$fbs_desc = opl_isset(strip_tags(stripslashes($instance['fbs_desc'])));
		$fbs_desc = str_replace(array("\r", "\n", "\r\n"), '', $fbs_desc);
		$fbs_img = opl_isset(trim(strip_tags(stripslashes($instance['fbs_img']))));
		$tws_desc = opl_isset(str_replace(array("\r", "\n", "\r\n"), '', stripslashes(strip_tags($instance['tws_desc']))));
		$is_fbshare = opl_isset($instance['is_fbshare']);
		$is_twshare = opl_isset($instance['is_twshare']);
		
		$data = array(
				'url' => $dl_url,
				'btn_color' => $btn_color,
				'btn_label' => $btn_label
			);
			
		if ( get_transient('opl-wgtv-' . $widget_id) == '' )
			set_transient('opl-wgtv-' . $widget_id, $data, 60*60*2);
		
		$fbs_img = ( filter_var($fbs_img, FILTER_VALIDATE_URL) ) ? $fbs_img : '';
		
		$body = '<div class="opl-viral-widget">';
		$body .= '<div class="textwidget">' . $text . '</div>';
		
		$body .= '<div style="margin:15px auto 10px auto; width:98%">';
		if ( $is_fbshare == 1 )
			$body .= '<div style="float:left; width:48%; margin-right:2%; margin-bottom:14px; text-align:right;"><strong><span class="opl-shadow-light" style="color:#a7a7a7; font-size:13px;"><em>Share on Facebook:</em></span></strong></div><div style="float:left; width:48%; margin-bottom:16px;"><a href="#" class="opl-wgt-fb-lock"><img src="' . OPL_URL . 'images/fb-share.png" border="0" style="vertical-align:middle; border:none !important; background: transparent !important;" /></a></div><div class="ibclearfix"></div>';
		
		if ( $is_twshare == 1 ) {
			$body .= '<div style="float:left; width:48%; margin-right:2%; margin-bottom:14px; text-align:right;"><strong><span class="opl-shadow-light" style="color:#a7a7a7; font-size:13px;"><em>Share on Twitter:</em></span></strong></div><div style="float:left; width:48%; margin-bottom:16px"><a href="https://twitter.com/share" class="twitter-share-button" data-url="' . $share_url . '" data-text="' . str_replace('"', '\"', $tws_desc) . '" data-count="none">Tweet</a></div><div class="ibclearfix"></div>';
		}
		$body .= '</div>';
		
		if ( isset($_COOKIE['__opl_wgt_unlock_' . $widget_id]) ) {
			$body .= '<div style="margin:10px auto; padding:15px; border-top:2px dashed #E5E5E5; text-align:center">';
			$body .= '<a href="' . $dl_url . '" target="_blank" class="opl-btn btn-' . $btn_color . '"><span>' . $btn_label . '</span></a>';
			$body .= '</div>';
		} else {
			$body .= '<div class="opl-wgt-download-holder" style="display:none; margin:10px auto; padding:15px; border-top:2px dashed #E5E5E5; text-align:center"><img src="' . OPL_URL . 'images/ajax-loader.gif" border="0" class="aligncenter" style="border:none !important; background: transparent !important;" /><br /><span style="color:#808080">Unlocking Content. Please wait...</span></div>';
		}

		$body .= '<input type="hidden" class="opl-wgt-viral-id" value="' . $widget_id . '" />';
		$body .= '<input type="hidden" class="opl-wgt-fbs-url" value="' . $share_url . '" />';
		$body .= '<input type="hidden" class="opl-wgt-fbs-title" value="' . str_replace('"', '\"', $fbs_title) . '" />';
		$body .= '<input type="hidden" class="opl-wgt-fbs-desc" value="' . str_replace('"', '\"', $fbs_desc) . '" />';
		$body .= '<input type="hidden" class="opl-wgt-fbs-img" value="' . $fbs_img . '" />';
		$body .= '</div>';
		
		$title = apply_filters('widget_title', empty($instance['title']) ? '&nbsp;' : $instance['title'], $instance, $this->id_base);
		
		if ( wp_get_theme() != 'Americana Mojave' ) echo $before_widget;
		if ( $title )
			echo $before_title . $title . $after_title;
		
		echo $body;
		
		if ( wp_get_theme() != 'Americana Mojave' ) echo $after_widget;
	}

	function update($new_instance, $old_instance) {
		if ( current_user_can('unfiltered_html') )
			$new_instance['text'] = $new_instance['text'];
		else
			$new_instance['text'] = stripslashes( wp_filter_post_kses( addslashes($new_instance['text']) ) ); // wp_filter_post_kses() expects slashed
		
		$new_instance['is_fbshare'] = ( isset($new_instance['is_fbshare']) ) ? 1 : 0;
		$new_instance['is_twshare'] = ( isset($new_instance['is_twshare']) ) ? 1 : 0;
		return $new_instance;
	}
	
	function form($instance) {
		$title = opl_isset(trim(strip_tags(stripslashes($instance['title']))));
		$text = opl_isset(esc_textarea($instance['text']));
		$btn_color = opl_isset(trim(strip_tags(stripslashes($instance['btn_color']))));
		$btn_label = opl_isset(trim(strip_tags(stripslashes($instance['btn_label']))));
		$dl_url = opl_isset(trim(strip_tags(stripslashes($instance['dl_url']))));
		$share_url = opl_isset(trim(strip_tags(stripslashes($instance['share_url']))));
		$fbs_title = opl_isset(trim(strip_tags(stripslashes($instance['fbs_title']))));
		$fbs_desc = opl_isset(esc_textarea(strip_tags($instance['fbs_desc'])));
		$fbs_img = opl_isset(trim(strip_tags(stripslashes($instance['fbs_img']))));
		$tws_desc = opl_isset(esc_textarea(strip_tags($instance['tws_desc'])));
		$is_fbshare = ( isset($instance['is_fbshare']) && $instance['is_fbshare'] == 1 ) ? ' checked="checked"' : '';
		$is_twshare = ( isset($instance['is_twshare']) && $instance['is_twshare'] == 1 ) ? ' checked="checked"' : '';
		
		echo '
		<p>
            	<label for="' . $this->get_field_id('title') . '">Title:</label>
            	<input type="text" name="' . $this->get_field_name('title') . '" value="' . $title . '" class="widefat" id="' . $this->get_field_id('title') . '" />
        </p>
        
		<p>
            	<label for="' . $this->get_field_id('text') . '">Text:</label>
            	<textarea name="' . $this->get_field_name('text') . '" class="widefat" id="' . $this->get_field_id('text') . '">' . $text . '</textarea>
        		<br />
				<small>' . __( 'You can enter an instruction on how to unlock the download here.' ) . '</small>
        </p>
        
		<p>
            	<label for="' . $this->get_field_id('dl_url') . '">Download URL:</label>
            	<input type="text" name="' . $this->get_field_name('dl_url') . '" value="' . $dl_url . '" class="widefat" id="' . $this->get_field_id('dl_url') . '" />
        </p>
        
		<p>
            	<label for="' . $this->get_field_id('btn_label') . '">Download Button Label:</label>
            	<input type="text" name="' . $this->get_field_name('btn_label') . '" value="' . $btn_label . '" class="widefat" id="' . $this->get_field_id('btn_label') . '" />
        </p>
        
        <p>
            	<label for="' . $this->get_field_id('btn_color') . '">Download Button Color:</label>
            	<select name="' . $this->get_field_name('btn_color') . '" id="' . $this->get_field_id('btn_color') . '" class="widefat">
		';

		$colors = array('yellow' => 'Yellow', 'orange' => 'Orange', 'green' => 'Green', 'blue' => 'Blue', 'grey' => 'Grey', 'red' => 'Red' );
		foreach ( $colors as $color => $option ) {
			$selected = ( $btn_color == $color ) ? ' selected="selected"' : '';
			echo '<option value="' . $color . '"' . $selected . '>' . $option . '</option>';
		}
		
		echo '
		</select>
        </p>
        
		<p>
            	<label for="' . $this->get_field_id('share_url') . '">URL To Share:</label>
            	<input type="text" name="' . $this->get_field_name('share_url') . '" value="' . $share_url . '" class="widefat" id="' . $this->get_field_id('share_url') . '" />
        		<br />
				<small>' . __( 'URL of a page that will be shared on Facebook or Twitter.' ) . '</small>
        </p>
        
		<p><input class="wgt-fbv-form" id="' . $this->get_field_id('is_fbshare') . '" name="' . $this->get_field_name('is_fbshare') . '" type="checkbox" value="1" ' . $is_fbshare . '/>&nbsp;<label for="' . $this->get_field_id('is_fbshare') . '">Enable Facebook Share</label></p>
		<p>
            	<label for="' . $this->get_field_id('fbs_title') . '">Facebook Share Title:</label>
            	<input type="text" name="' . $this->get_field_name('fbs_title') . '" value="' . $fbs_title . '" class="widefat" id="' . $this->get_field_id('fbs_title') . '" />
        </p>
        <p>
            	<label for="' . $this->get_field_id('fbs_desc') . '">Facebook Share Message:</label>
            	<textarea name="' . $this->get_field_name('fbs_desc') . '" class="widefat" id="' . $this->get_field_id('fbs_desc') . '">' . $fbs_desc . '</textarea>
        </p>
        <p>
            	<label for="' . $this->get_field_id('fbs_img') . '">Facebook Share Image (optional):</label>
            	<input type="text" name="' . $this->get_field_name('fbs_img') . '" value="' . $fbs_img . '" class="widefat" id="' . $this->get_field_id('fbs_img') . '" />
        		<br />
				<small>' . __( 'You can enter an image URL if you want to include an image/thumbnail to be shared on Facebook.' ) . '</small>
        </p>
        
		<p><input class="wgt-twv-form" id="' . $this->get_field_id('is_twshare') . '" name="' . $this->get_field_name('is_twshare') . '" type="checkbox" value="1" ' . $is_twshare . '/>&nbsp;<label for="' . $this->get_field_id('is_twshare') . '">Enable Twitter Share</label></p>
        <p>
            	<label for="' . $this->get_field_id('tws_desc') . '">Twitter Share Message:</label>
            	<textarea name="' . $this->get_field_name('tws_desc') . '" class="widefat" id="' . $this->get_field_id('tws_desc') . '">' . $tws_desc . '</textarea>
        </p>
        ';
	}
}

class oplTabWidget extends WP_Widget {
	function __construct() {
		$widget_ops = array('classname' => 'opl_tab_content_widget', 'description' => __('Widget to display tabbed content'));
		$control_ops = array('width' => 400, 'height' => 350);
		parent::__construct('opl_tabbed_widget', __('InstaBuilder - Tabbed Content'), $widget_ops, $control_ops);
	}
	
	function widget($args, $instance) {
		extract($args);
		
		global $opl_ts, $opl_tc;
		
		$title = apply_filters( 'widget_title', empty( $instance['title'] ) ? '' : $instance['title'], $instance, $this->id_base );
		
		$tab1 = opl_isset(trim(stripslashes($instance['tab1'])));
		$tab2 = opl_isset(trim(stripslashes($instance['tab2'])));
		$tab3 = opl_isset(trim(stripslashes($instance['tab3'])));
		$tab4 = opl_isset(trim(stripslashes($instance['tab4'])));
		
		$text1 = opl_isset(trim(stripslashes($instance['text1'])));
		$text2 = opl_isset(trim(stripslashes($instance['text2'])));
		$text3 = opl_isset(trim(stripslashes($instance['text3'])));
		$text4 = opl_isset(trim(stripslashes($instance['text4'])));
		
		$tabs = array($tab1, $tab2, $tab3, $tab4);
		$texts = array($text1, $text2, $text3, $text4);
		
		if ( wp_get_theme() != 'Americana Mojave' ) echo $before_widget;
		if ( !empty( $title ) ) { echo $before_title . $title . $after_title; }
		
		$contents = array();

		echo '<div id="opl-tabs">';
		echo '<ul class="opl-tab-titles">';
		for ( $i = 0; $i < 4; $i++ ) {
			if ( $tabs[$i] != '' ) {
				$opl_ts++;
				$tab_ID = 'opl-tab-' . $opl_ts;
				echo '<li><a href="#" rel="' . $tab_ID . '" class="opl-tab"><span>' . $tabs[$i] . '</span></a></li>';
				$contents[] = $texts[$i];
			}
		}
	
		echo '</ul>';
		echo '<div class="ibclearfix"></div>';
		echo '<ul class="opl-tab-contents">';
		
		//for ( $i = 0; $i < count($contents); $i++ ) {
		foreach ( $contents as $content ) {
			$opl_tc++;
			$text_ID = 'opl-tab-' . $opl_tc;
			echo '<li id="' . $text_ID . '" class="opl-tab-content"><div class="textwidget">' . $content . '</div></li>';
		}
	
		echo '</ul>';
		echo '</div>';
	
		if ( wp_get_theme() != 'Americana Mojave' ) echo $after_widget;
		
	}
	
	function update($new_instance, $old_instance) {
		if ( current_user_can('unfiltered_html') ) {
			$new_instance['text1'] = $new_instance['text1'];
			$new_instance['text2'] = $new_instance['text2'];
			$new_instance['text3'] = $new_instance['text3'];
			$new_instance['text4'] = $new_instance['text4'];
		} else {
			$new_instance['text1'] = stripslashes( wp_filter_post_kses( addslashes($new_instance['text1']) ) ); // wp_filter_post_kses() expects slashed
			$new_instance['text2'] = stripslashes( wp_filter_post_kses( addslashes($new_instance['text2']) ) ); // wp_filter_post_kses() expects slashed
			$new_instance['text3'] = stripslashes( wp_filter_post_kses( addslashes($new_instance['text3']) ) ); // wp_filter_post_kses() expects slashed
			$new_instance['text4'] = stripslashes( wp_filter_post_kses( addslashes($new_instance['text4']) ) ); // wp_filter_post_kses() expects slashed
		}
		return $new_instance;
	}
	
	function form($instance) {
		$title = opl_isset(trim(strip_tags(stripslashes($instance['title']))));
		$tab1 = opl_isset(trim(strip_tags(stripslashes($instance['tab1']))));
		$tab2 = opl_isset(trim(strip_tags(stripslashes($instance['tab2']))));
		$tab3 = opl_isset(trim(strip_tags(stripslashes($instance['tab3']))));
		$tab4 = opl_isset(trim(strip_tags(stripslashes($instance['tab4']))));
		
		$text1 = opl_isset(esc_textarea($instance['text1']));
		$text2 = opl_isset(esc_textarea($instance['text2']));
		$text3 = opl_isset(esc_textarea($instance['text3']));
		$text4 = opl_isset(esc_textarea($instance['text4']));
		
		echo '
		<p>
            	<label for="' . $this->get_field_id('title') . '">Title:</label>
            	<input type="text" name="' . $this->get_field_name('title') . '" value="' . $title . '" class="widefat" id="' . $this->get_field_id('title') . '" />
        </p>
        
		<p>
            	<label for="' . $this->get_field_id('tab1') . '">Tab #1 Name:</label>
            	<input type="text" name="' . $this->get_field_name('tab1') . '" value="' . $tab1 . '" class="widefat" id="' . $this->get_field_id('tab1') . '" />
        </p>
        
		<p>
            	<label for="' . $this->get_field_id('text1') . '">Tab #1 Content:</label>
            	<textarea name="' . $this->get_field_name('text1') . '" class="widefat" id="' . $this->get_field_id('text1') . '">' . $text1 . '</textarea>
        </p>
        
		<p>
            	<label for="' . $this->get_field_id('tab2') . '">Tab #2 Name:</label>
            	<input type="text" name="' . $this->get_field_name('tab2') . '" value="' . $tab2 . '" class="widefat" id="' . $this->get_field_id('tab2') . '" />
        </p>
        
		<p>
            	<label for="' . $this->get_field_id('text2') . '">Tab #2 Content:</label>
            	<textarea name="' . $this->get_field_name('text2') . '" class="widefat" id="' . $this->get_field_id('text2') . '">' . $text2 . '</textarea>
        </p>
        
		<p>
            	<label for="' . $this->get_field_id('tab3') . '">Tab #3 Name:</label>
            	<input type="text" name="' . $this->get_field_name('tab3') . '" value="' . $tab3 . '" class="widefat" id="' . $this->get_field_id('tab3') . '" />
        </p>
        
		<p>
            	<label for="' . $this->get_field_id('text3') . '">Tab #3 Content:</label>
            	<textarea name="' . $this->get_field_name('text3') . '" class="widefat" id="' . $this->get_field_id('text3') . '">' . $text3 . '</textarea>
        </p>
        
		<p>
            	<label for="' . $this->get_field_id('tab4') . '">Tab #4 Name:</label>
            	<input type="text" name="' . $this->get_field_name('tab4') . '" value="' . $tab4 . '" class="widefat" id="' . $this->get_field_id('tab4') . '" />
        </p>
        
		<p>
            	<label for="' . $this->get_field_id('text4') . '">Tab #4 Content:</label>
            	<textarea name="' . $this->get_field_name('text4') . '" class="widefat" id="' . $this->get_field_id('text4') . '">' . $text4 . '</textarea>
        </p>
        ';
	}
}

class oplVideoPlayerWidget extends WP_Widget {
	function __construct() {
		$widget_ops = array('classname' => 'opl_video_player_widget', 'description' => __('Widget to display video on your sidebar'));
		$control_ops = array('width' => 400, 'height' => 350);
		parent::__construct('opl_videoplay_widget', __('InstaBuilder - Video Player'), $widget_ops, $control_ops);
	}
	
	function widget($args, $instance) {
		extract($args);
		
		$video_url = opl_isset(trim(esc_attr(stripslashes($instance['video_url']))));
		$player = opl_isset(trim($instance['player']));
		$width = opl_isset(trim(esc_attr(stripslashes($instance['width']))));
		$height = opl_isset(trim(esc_attr(stripslashes($instance['height']))));
		$splash_url = opl_isset(trim(esc_attr(stripslashes($instance['splash_url']))));
		$autoplay = opl_isset($instance['autoplay']);
		$autohide = opl_isset($instance['autohide']);
		$dis_control = opl_isset($instance['dis_control']);
		
		$title = apply_filters( 'widget_title', empty( $instance['title'] ) ? '' : $instance['title'], $instance, $this->id_base );
		if ( wp_get_theme() != 'Americana Mojave' ) echo $before_widget;
		if ( $title )
			echo $before_title . $title . $after_title;
		
		$video = array();
		$video['video_url'] = $video_url;
		$video['ivideo_url'] = '';
		$video['video_width'] = $width;
		$video['video_height'] = $height;
		$video['autoplay'] = $autoplay;
		$video['autohide'] = $autohide;
		$video['disable_control'] = $dis_control;
		$video['video_scr'] = $splash_url;
		
		echo '<div class="opl-vid-shadow" style="margin-bottom:25px; max-width:' . $width . 'px; max-height:' . $height . 'px">';
		if ( $player == 'flow' ) {
			echo opl_flowplayer( $video );
		} else if ( $player == 'jw' ) {
			echo opl_jwplayer( $video );
		}
		echo '</div>' . "\n\n";
	
		if ( wp_get_theme() != 'Americana Mojave' ) echo $after_widget;
	}
	
	function update($new_instance, $old_instance) {
		$new_instance['autoplay'] = ( isset($new_instance['autoplay']) ) ? 1 : 0;
		$new_instance['autohide'] = ( isset($new_instance['autohide']) ) ? 1 : 0;
		$new_instance['dis_control'] = ( isset($new_instance['dis_control']) ) ? 1 : 0;
		return $new_instance;
	}
	
	function form($instance) {
		$title = opl_isset(trim(strip_tags(stripslashes($instance['title']))));
		$video_url = opl_isset(trim(strip_tags(stripslashes($instance['video_url']))));
		$player = opl_isset(trim($instance['player']));
		$width = ( opl_isset($instance['width']) != '' ) ? trim(strip_tags(stripslashes($instance['width']))) : '270';
		$height = ( opl_isset($instance['height']) != '' ) ? trim(strip_tags(stripslashes($instance['height']))) : '152';
		$splash_url = opl_isset(trim(strip_tags(stripslashes($instance['splash_url']))));
		$autoplay = ( opl_isset($instance['autoplay']) == 1 ) ? ' checked="checked"' : '';
		$autohide = ( opl_isset($instance['autohide']) == 1 ) ? ' checked="checked"' : '';
		$dis_control = ( opl_isset($instance['dis_control']) == 1 ) ? ' checked="checked"' : '';
		
		$jw_disable = ( !function_exists('jwplayer_plugin_menu') ) ? ' disabled="disabled"' : '';
		$jw_selected = ( $player == 'jw' ) ? ' selected="selected"' : '';
		$flow_selected = ( $player == 'flow' ) ? ' selected="selected"' : '';
		
		echo '
		<p>
            	<label for="' . $this->get_field_id('title') . '">Title:</label>
            	<input type="text" name="' . $this->get_field_name('title') . '" value="' . $title . '" class="widefat" id="' . $this->get_field_id('title') . '" />
        </p>
		<p>
        	<label for="' . $this->get_field_id('player') . '">Video Player:</label>
        	<select name="' . $this->get_field_name('player') . '" id="' . $this->get_field_id('player') . '" class="widefat">
				<option value="flow"' . $flow_selected . '>Flowplayer</option>
				<option value="jw"' . $jw_selected . $jw_disable . '>JW Player</option>
			</select>
			<br />
			<small>If you want to use JW Player, you must install and activate <a href="' . admin_url('plugin-install.php?tab=search&type=term&s=JW+Player&plugin-search-input=Search+Plugins') . '" target="_blank">JW Player for WordPress</a> by <a href="http://www.longtailvideo.com" target="_blank">LongTail Video, Inc</a>.</small>
        </p>
        <p>
            	<label for="' . $this->get_field_id('video_url') . '">Video URL:</label>
            	<input type="text" name="' . $this->get_field_name('video_url') . '" value="' . $video_url . '" class="widefat" id="' . $this->get_field_id('video_url') . '" />
        </p>
        <p>
            	<label for="' . $this->get_field_id('width') . '">Video Width:</label>
            	<input type="text" name="' . $this->get_field_name('width') . '" value="' . $width . '" class="widefat" id="' . $this->get_field_id('width') . '" />
        </p>
        <p>
            	<label for="' . $this->get_field_id('height') . '">Video Height:</label>
            	<input type="text" name="' . $this->get_field_name('height') . '" value="' . $height . '" class="widefat" id="' . $this->get_field_id('height') . '" />
        </p>
        <p>
            	<label for="' . $this->get_field_id('splash_url') . '">Splash Image URL (optional):</label>
            	<input type="text" name="' . $this->get_field_name('splash_url') . '" value="' . $splash_url . '" class="widefat" id="' . $this->get_field_id('splash_url') . '" />
        </p>
        <p><input id="' . $this->get_field_id('autoplay') . '" name="' . $this->get_field_name('autoplay') . '" type="checkbox" value="1" ' . $autoplay . '/>&nbsp;<label for="' . $this->get_field_id('autoplay') . '">Enable Auto Play</label></p>
        <p><input id="' . $this->get_field_id('autohide') . '" name="' . $this->get_field_name('autohide') . '" type="checkbox" value="1" ' . $autohide . '/>&nbsp;<label for="' . $this->get_field_id('autohide') . '">Enable Auto Hide Control</label></p>
        <p><input id="' . $this->get_field_id('dis_control') . '" name="' . $this->get_field_name('dis_control') . '" type="checkbox" value="1" ' . $dis_control . '/>&nbsp;<label for="' . $this->get_field_id('dis_control') . '">Disable Video Control</label></p>
        ';
	}
}

class oplEmbedVideoWidget extends WP_Widget {
	function __construct() {
		$widget_ops = array('classname' => 'opl_embed_video_widget', 'description' => __('Widget to embed video code from external video platform or video sharing sites.'));
		$control_ops = array('width' => 400, 'height' => 350);
		parent::__construct('opl_embedvideo_widget', __('InstaBuilder - Embed Video'), $widget_ops, $control_ops);
	}
	
	function widget($args, $instance) {
		extract($args);
		
		$title = apply_filters( 'widget_title', empty( $instance['title'] ) ? '' : $instance['title'], $instance, $this->id_base );
		if ( wp_get_theme() != 'Americana Mojave' ) echo $before_widget;
		if ( $title )
			echo $before_title . $title . $after_title;
		
		$code = trim(opl_isset($instance['code']));
		echo '<div class="opl-vid-wrap">' . trim(stripslashes($code)) . '</div>';
		
		if ( wp_get_theme() != 'Americana Mojave' ) echo $after_widget;
	}
	
	function update($new_instance, $old_instance) {
		if ( current_user_can('unfiltered_html') )
			$new_instance['code'] = $new_instance['code'];
		else
			$new_instance['code'] = stripslashes( wp_filter_post_kses( addslashes($new_instance['code']) ) ); // wp_filter_post_kses() expects slashed
		return $new_instance;
	}
	
	function form($instance) {
		$title = opl_isset(trim(strip_tags(stripslashes($instance['title']))));
		$code = opl_isset(esc_textarea(stripslashes($instance['code'])));
		
		echo '
		<p>
            	<label for="' . $this->get_field_id('title') . '">Title:</label>
            	<input type="text" name="' . $this->get_field_name('title') . '" value="' . $title . '" class="widefat" id="' . $this->get_field_id('title') . '" />
        </p>
        <p>
            	<label for="' . $this->get_field_id('code') . '">Video Embed Code:</label>
            	<textarea name="' . $this->get_field_name('code') . '" class="widefat" id="' . $this->get_field_id('code') . '">' . $code . '</textarea>
        </p>
        ';
	}
}

class oplPopContentWidget extends WP_Widget {
	function __construct() {
		$widget_ops = array('classname' => 'opl_popup_content_widget', 'description' => __('Widget to add a pop up content on your sidebar'));
		$control_ops = array('width' => 400, 'height' => 350);
		parent::__construct('opl_popcontent_widget', __('InstaBuilder - Pop Up Content'), $widget_ops, $control_ops);
	}
	
	function widget($args, $instance) {
		extract($args);
		
		global $opl_pi, $ezjs_colorbox;
		
		$title = apply_filters( 'widget_title', empty( $instance['title'] ) ? '' : $instance['title'], $instance, $this->id_base );
		$code = trim(stripslashes(opl_isset($instance['code'])));
		$link = opl_isset(trim(esc_attr(stripslashes($instance['link']))));
		$thumb = opl_isset(trim(esc_attr(stripslashes($instance['thumb']))));
		$pop_width = ( is_numeric(opl_isset($instance['width'])) && $instance['width'] > 0 ) ? ', width:"' . $instance['width'] . '"' : ', width:"450"';
		$pop_height = ( is_numeric(opl_isset($instance['height'])) && $instance['height'] > 0 ) ? ', height:"' . $instance['height'] . '"' : '';
	
		$is_thumb = ( $thumb != '' && filter_var($thumb, FILTER_VALIDATE_URL) ) ? true : false;
	
		if ( wp_get_theme() != 'Americana Mojave' ) echo $before_widget;
		if ( $title )
			echo $before_title . $title . $after_title;
		
		if ( $ezjs_colorbox === FALSE && !class_exists('GalleryPlugin') ) {
			$GLOBALS['ezjs_colorbox'] = true;
			echo '<script type="text/javascript" src="' . OPL_URL . 'js/colorbox/jquery.colorbox-min.js"></script>';
		}
		
		echo '<a href="#" id="opl-pop-' . $opl_pi . '" class="opl-colorbox" style="display:block; margin-bottom:15px; overflow:hidden">';
	
		if ( $is_thumb )
			echo '<img src="' . $thumb . '" border="0" style="border:none !important; background:none !important; max-width:100%; height: auto" /><br />';
		
		if ( $link != '' )
			echo $link;
		
		echo '</a>';
		
		echo '<div id="opl-inline-' . $opl_pi . '" style="display:none;"><div class="opl_pop_holder" style="padding:30px 20px 20px 20px">' . wpautop($code) . '</div></div>';
		
		echo '<script type="text/javascript">';
		echo 'jQuery(document).ready(function($){';
		echo 'var icontent = $("#opl-inline-' . $opl_pi . '").html();';
		echo '$("#opl-pop-' . $opl_pi . '").colorbox({html:icontent' . $pop_width . $pop_height . '});';
		echo '});';
		echo '</script>';
	
		$opl_pi++;
		
		if ( wp_get_theme() != 'Americana Mojave' ) echo $after_widget;
	}
	
	function update($new_instance, $old_instance) {
		if ( current_user_can('unfiltered_html') )
			$new_instance['code'] = $new_instance['code'];
		else
			$new_instance['code'] = stripslashes( wp_filter_post_kses( addslashes($new_instance['code']) ) ); // wp_filter_post_kses() expects slashed
		return $new_instance;
	}
	
	function form($instance) {
		$title = opl_isset(trim(strip_tags(stripslashes($instance['title']))));
		$link = opl_isset(trim(strip_tags(stripslashes($instance['link']))));
		$thumb = opl_isset(trim(strip_tags(stripslashes($instance['thumb']))));
		$code = opl_isset(esc_textarea(stripslashes($instance['code'])));
		$width = ( opl_isset($instance['width']) != '' ) ? trim(strip_tags(stripslashes($instance['width']))) : '450';
		$height = ( opl_isset($instance['height']) != '' ) ? trim(strip_tags(stripslashes($instance['height']))) : '300';
		
		echo '
		<p>
            	<label for="' . $this->get_field_id('title') . '">Title:</label>
            	<input type="text" name="' . $this->get_field_name('title') . '" value="' . $title . '" class="widefat" id="' . $this->get_field_id('title') . '" />
        </p>
        <p>
            	<label for="' . $this->get_field_id('link') . '">Pop Up Text Link:</label>
            	<input type="text" name="' . $this->get_field_name('link') . '" value="' . $link . '" class="widefat" id="' . $this->get_field_id('link') . '" />
        		<br />
				<small>Text link that can be clicked to display the pop up.</small>
        </p>
        <p>
            	<label for="' . $this->get_field_id('thumb') . '">Pop Up Thumbnail URL (optional):</label>
            	<input type="text" name="' . $this->get_field_name('thumb') . '" value="' . $thumb . '" class="widefat" id="' . $this->get_field_id('thumb') . '" />
        </p>
        <p>
            	<label for="' . $this->get_field_id('code') . '">Pop Up Content:</label>
            	<textarea name="' . $this->get_field_name('code') . '" class="widefat" id="' . $this->get_field_id('code') . '">' . $code . '</textarea>
        		<br />
				<small>You can use HTML to format your content, insert images, and embed video.</small>
        </p>
        <p>
            	<label for="' . $this->get_field_id('width') . '">Pop Up Width:</label>
            	<input type="text" name="' . $this->get_field_name('width') . '" value="' . $width . '" class="widefat" id="' . $this->get_field_id('width') . '" />
        </p>
        <p>
            	<label for="' . $this->get_field_id('height') . '">Pop Up Height:</label>
            	<input type="text" name="' . $this->get_field_name('height') . '" value="' . $height . '" class="widefat" id="' . $this->get_field_id('height') . '" />
        </p>
        ';
	}
}

class oplPopImageWidget extends WP_Widget {
	function __construct() {
		$widget_ops = array('classname' => 'opl_popup_image_widget', 'description' => __('Widget to add a pop up image on your sidebar'));
		$control_ops = array('width' => 400, 'height' => 350);
		parent::__construct('opl_popimage_widget', __('InstaBuilder - Pop Up Image'), $widget_ops, $control_ops);
	}
	
	function widget($args, $instance) {
		extract($args);
		
		global $opl_pi, $ezjs_colorbox;
		
		$title = apply_filters( 'widget_title', empty( $instance['title'] ) ? '' : $instance['title'], $instance, $this->id_base );
		$link = opl_isset(trim(esc_attr(stripslashes($instance['link']))));
		$thumb = opl_isset(trim(esc_attr(stripslashes($instance['thumb']))));
		$img = opl_isset(trim(esc_attr(stripslashes($instance['img']))));
		
		$is_thumb = ( $thumb != '' && filter_var($thumb, FILTER_VALIDATE_URL) ) ? true : false;
	
		if ( wp_get_theme() != 'Americana Mojave' ) echo $before_widget;
		if ( $title )
			echo $before_title . $title . $after_title;
		
		if ( $ezjs_colorbox === FALSE && !class_exists('GalleryPlugin') ) {
			$GLOBALS['ezjs_colorbox'] = true;
			echo '<script type="text/javascript" src="' . OPL_URL . 'js/colorbox/jquery.colorbox-min.js"></script>';
		}
		
		echo '<a href="#" id="opl-pop-' . $opl_pi . '" class="opl-colorbox" style="display:block; margin-bottom:15px; overflow:hidden">';
	
		if ( $is_thumb )
			echo '<img src="' . $thumb . '" border="0" style="border:none !important; background:none !important; max-width:100%; height: auto" /><br />';
		
		if ( $link != '' )
			echo $link;
		
		echo '</a>';
		
		echo '<script type="text/javascript">';
		echo 'jQuery(document).ready(function($){';
		echo 'var icontent = $("#opl-inline-' . $opl_pi . '").html();';
		echo '$("#opl-pop-' . $opl_pi . '").colorbox({photo:true, href:"' . $img . '"});';
		echo '});';
		echo '</script>';
	
		$opl_pi++;
		
		if ( wp_get_theme() != 'Americana Mojave' ) echo $after_widget;
	}
	
	function update($new_instance, $old_instance) {
		return $new_instance;
	}
	
	function form($instance) {
		$title = opl_isset(trim(strip_tags(stripslashes($instance['title']))));
		$link = opl_isset(trim(strip_tags(stripslashes($instance['link']))));
		$thumb = opl_isset(trim(strip_tags(stripslashes($instance['thumb']))));
		$img = opl_isset(trim(strip_tags(stripslashes($instance['img']))));
		
		echo '
		<p>
            	<label for="' . $this->get_field_id('title') . '">Title:</label>
            	<input type="text" name="' . $this->get_field_name('title') . '" value="' . $title . '" class="widefat" id="' . $this->get_field_id('title') . '" />
        </p>
        <p>
            	<label for="' . $this->get_field_id('link') . '">Pop Up Text Link:</label>
            	<input type="text" name="' . $this->get_field_name('link') . '" value="' . $link . '" class="widefat" id="' . $this->get_field_id('link') . '" />
        		<br />
				<small>Text link that can be clicked to display the pop up.</small>
        </p>
        <p>
            	<label for="' . $this->get_field_id('thumb') . '">Pop Up Thumbnail URL (optional):</label>
            	<input type="text" name="' . $this->get_field_name('thumb') . '" value="' . $thumb . '" class="widefat" id="' . $this->get_field_id('thumb') . '" />
        </p>
        <p>
            	<label for="' . $this->get_field_id('img') . '">Pop Up Main Image URL:</label>
            	<input type="text" name="' . $this->get_field_name('img') . '" value="' . $img . '" class="widefat" id="' . $this->get_field_id('img') . '" />
        </p>
        ';
	}
}

class oplSocialWidget extends WP_Widget {
	function __construct() {
		$widget_ops = array('classname' => 'opl_social_widget', 'description' => __('Widget to display share buttons from several social sites'));
		$control_ops = array('width' => 400, 'height' => 350);
		parent::__construct('opl_socialshare_widget', __('InstaBuilder - Social Share'), $widget_ops, $control_ops);
	}
	
	function widget($args, $instance) {
		extract($args);
		
		$title = apply_filters( 'widget_title', empty( $instance['title'] ) ? '' : $instance['title'], $instance, $this->id_base );
		$facebook = opl_isset($instance['facebook']);
		$twitter = opl_isset($instance['twitter']);
		$google = opl_isset($instance['google']);
		$pinterest = opl_isset($instance['pinterest']);
		$linkedin = opl_isset($instance['linkedin']);
		$su = opl_isset($instance['su']);

		global $post;
		
		if ( wp_get_theme() != 'Americana Mojave' ) echo $before_widget;

		if ( $title )
			echo $before_title . $title . $after_title;
		
		if ( $pinterest == 1 ) {
			
			if ( !function_exists('has_post_thumbnail') )
				require_once (ABSPATH . 'wp-includes/post-thumbnail-template.php');
			
			$post_thumbnail_id = get_post_thumbnail_id( $post->ID );
			$src = wp_get_attachment_image_src( $post_thumbnail_id );
			$image = '';
			if ( has_post_thumbnail($post->ID) ) {
					$image = $src[0];
			} else {
					$output = preg_match_all( '/<img.+src=[\'"]([^\'"]+)[\'"].*>/i', $post->post_content, $matches );
					$image = opl_isset($matches[1][0]);
			}
			
			$pin_media = ( $image != '' ) ? '&media=' . urlencode($image) : '&media=';
		}
		
		$proto = ( function_exists('is_ssl') && is_ssl() ) ? 'https://' : 'http://';
		$share_url = $proto . $_SERVER['HTTP_HOST'] . $_SERVER['REQUEST_URI'];
		
		if ( is_singular() ) {
			$message = $post->post_title;
		} else {
			$message = get_option('blogname') . '-' . get_option('blogdesc');
		}
		$message = str_replace(array("\n", "\r"), '', wptexturize($message));
		
		echo '<ul style="margin:0; padding:0; list-style:none">';
		if ( $facebook == 1 ) {
			echo '<li style="float:left; margin:0; padding:0 5px 5px 0; list-style-type:none; display:block; height:70px"><div class="fb-like" data-href="' . $share_url . '" data-send="false" data-layout="box_count" data-width="49" data-show-faces="true" style="width:49px;margin:0 auto 7px auto"></div></li>' . "\n";
		}
		if ( $twitter == 1 ) {
			echo '<li style="float:left; margin:0; padding:0 5px 5px 0; list-style-type:none; display:block; height:70px"><div style="width:59px;"><script src="http://platform.twitter.com/widgets.js" type="text/javascript"></script><a href="http://twitter.com/share" class="twitter-share-button" data-url="' . $share_url . '" data-text="' . $message . '"  data-count="vertical">Tweet</a></div></li>';
		}
		if ( $google == 1 ) {
			echo '<li style="float:left; margin:0; padding:0 5px 5px 0; list-style-type:none; display:block; height:70px"><div style="width:52px;"><script type="text/javascript" src="http://apis.google.com/js/plusone.js"></script><g:plusone size="tall"></g:plusone></div></li>';
		}
		if ( $pinterest == 1 ) {
			echo '<li style="float:left; margin:0; padding:15px 5px 5px 0; list-style-type:none; display:block; height:55px"><div style="width:45px;"><a href="http://pinterest.com/pin/create/button/?url=' . urlencode($share_url) . $pin_media . '" class="pin-it-button" count-layout="vertical"><img border="0" src="//assets.pinterest.com/images/PinExt.png" title="Pin It" /></a></div></li>';
			echo '<script type="text/javascript" src="//assets.pinterest.com/js/pinit.js"></script>';
		}
		if ( $linkedin == 1 ) { 
			echo '<li style="float:left; margin:0; padding:0 5px 5px 0; list-style-type:none; display:block; height:70px"><div style="width:62px;"><script src="//platform.linkedin.com/in.js" type="text/javascript"></script><script type="IN/Share" data-url="' . $share_url . '" data-counter="top"></script></div></li>';
		}
		if ( $su == 1 ) {
			echo '<li style="float:left; margin:0; padding:0 5px 5px 0; list-style-type:none; display:block; height:70px"><div style="width:50px;"><su:badge layout="5"></su:badge></div></li>';
			echo '
			<script type="text/javascript">
			  (function() {
			    var li = document.createElement("script"); li.type = "text/javascript"; li.async = true;
			    li.src = "https://platform.stumbleupon.com/1/widgets.js";
			    var s = document.getElementsByTagName("script")[0]; s.parentNode.insertBefore(li, s);
			  })();
			</script>
			';
		}
		echo '</ul>';
		echo '<div style="clear:left"></div>';
		if ( wp_get_theme() != 'Americana Mojave' ) echo $after_widget;
	}
	
	function update($new_instance, $old_instance) {
		$new_instance['facebook'] = ( isset($new_instance['facebook']) ) ? 1 : 0;
		$new_instance['twitter'] = ( isset($new_instance['twitter']) ) ? 1 : 0;
		$new_instance['google'] = ( isset($new_instance['google']) ) ? 1 : 0;
		$new_instance['pinterest'] = ( isset($new_instance['pinterest']) ) ? 1 : 0;
		$new_instance['linkedin'] = ( isset($new_instance['linkedin']) ) ? 1 : 0;
		$new_instance['su'] = ( isset($new_instance['su']) ) ? 1 : 0;
		return $new_instance;
	}
	
	function form($instance) {
		$title = opl_isset(trim(strip_tags(stripslashes($instance['title']))));
		$facebook = ( opl_isset($instance['facebook']) == 1 ) ? ' checked="checked"' : '';
		$twitter = ( opl_isset($instance['twitter']) == 1 ) ? ' checked="checked"' : '';
		$google = ( opl_isset($instance['google']) == 1 ) ? ' checked="checked"' : '';
		$pinterest = ( opl_isset($instance['pinterest']) == 1 ) ? ' checked="checked"' : '';
		$linkedin = ( opl_isset($instance['linkedin']) == 1 ) ? ' checked="checked"' : '';
		$su = ( opl_isset($instance['su']) == 1 ) ? ' checked="checked"' : '';
		
		echo '
		<p>
            	<label for="' . $this->get_field_id('title') . '">Title:</label>
            	<input type="text" name="' . $this->get_field_name('title') . '" value="' . $title . '" class="widefat" id="' . $this->get_field_id('title') . '" />
        </p>
		<p><input id="' . $this->get_field_id('facebook') . '" name="' . $this->get_field_name('facebook') . '" type="checkbox" value="1" ' . $facebook . '/>&nbsp;<label for="' . $this->get_field_id('facebook') . '">Facebook</label></p>
		<p><input id="' . $this->get_field_id('twitter') . '" name="' . $this->get_field_name('twitter') . '" type="checkbox" value="1" ' . $twitter . '/>&nbsp;<label for="' . $this->get_field_id('twitter') . '">Twitter</label></p>
		<p><input id="' . $this->get_field_id('google') . '" name="' . $this->get_field_name('google') . '" type="checkbox" value="1" ' . $google . '/>&nbsp;<label for="' . $this->get_field_id('google') . '">Google +1</label></p>
		<p><input id="' . $this->get_field_id('pinterest') . '" name="' . $this->get_field_name('pinterest') . '" type="checkbox" value="1" ' . $pinterest . '/>&nbsp;<label for="' . $this->get_field_id('pinterest') . '">Pinterest</label></p>
		<p><input id="' . $this->get_field_id('linkedin') . '" name="' . $this->get_field_name('linkedin') . '" type="checkbox" value="1" ' . $linkedin . '/>&nbsp;<label for="' . $this->get_field_id('linkedin') . '">LinkedIn</label></p>
		<p><input id="' . $this->get_field_id('su') . '" name="' . $this->get_field_name('su') . '" type="checkbox" value="1" ' . $su . '/>&nbsp;<label for="' . $this->get_field_id('su') . '">StumbleUpon</label></p>
		';
	}
}

add_action( 'widgets_init', 'opl_register_widget' );
function opl_register_widget() {
	register_widget('oplSidebarOptin');
	register_widget('oplCountdownWidget');
	register_widget('oplViralWidget');
	register_widget('oplTabWidget');
	register_widget('oplVideoPlayerWidget');
	register_widget('oplEmbedVideoWidget');
	register_widget('oplPopContentWidget');
	register_widget('oplPopImageWidget');
	register_widget('oplSocialWidget');
}

function opl_timezone_list() {
	$timezone = array(
			"UTC-12" => "UTC-12",
			"UTC-11.5" => "UTC-11:30",
			"UTC-11" => "UTC-11",
			"UTC-10.5" => "UTC-10:30",
			"UTC-10" => "UTC-10",
			"UTC-9.5" => "UTC-9:30",
			"UTC-9" => "UTC-9",
			"UTC-8.5" => "UTC-8:30",
			"UTC-8" => "UTC-8",
			"UTC-7.5" => "UTC-7:30",
			"UTC-7" => "UTC-7",
			"UTC-6.5" => "UTC-6:30",
			"UTC-6" => "UTC-6",
			"UTC-5.5" => "UTC-5:30",
			"UTC-5" => "UTC-5",
			"UTC-4.5" => "UTC-4:30",
			"UTC-4" => "UTC-4",
			"UTC-3.5" => "UTC-3:30",
			"UTC-3" => "UTC-3",
			"UTC-2.5" => "UTC-2:30",
			"UTC-2" => "UTC-2",
			"UTC-1.5" => "UTC-1:30",
			"UTC-1" => "UTC-1",
			"UTC-0.5" => "UTC-0:30",
			"UTC" => "UTC",
			"UTC+0.5" => "UTC+0:30",
			"UTC+1" => "UTC+1",
			"UTC+1.5" => "UTC+1:30",
			"UTC+2" => "UTC+2",
			"UTC+2.5" => "UTC+2:30",
			"UTC+3" => "UTC+3",
			"UTC+3.5" => "UTC+3:30",
			"UTC+4" => "UTC+4",
			"UTC+4.5" => "UTC+4:30",
			"UTC+5" => "UTC+5",
			"UTC+5.5" => "UTC+5:30",
			"UTC+5.75" => "UTC+5:45",
			"UTC+6" => "UTC+6",
			"UTC+6.5" => "UTC+6:30",
			"UTC+7" => "UTC+7",
			"UTC+7.5" => "UTC+7:30",
			"UTC+8" => "UTC+8",
			"UTC+8.5" => "UTC+8:30",
			"UTC+8.75" => "UTC+8:45",
			"UTC+9" => "UTC+9",
			"UTC+9.5" => "UTC+9:30",
			"UTC+10" => "UTC+10",
			"UTC+10.5" => "UTC+10:30",
			"UTC+11" => "UTC+11",
			"UTC+11.5" => "UTC+11:30",
			"UTC+12" => "UTC+12",
			"UTC+12.75" => "UTC+12:45",
			"UTC+13" => "UTC+13",
			"UTC+13.75" => "UTC+13:45",
			"UTC+14" => "UTC+14"
	);
	
	return $timezone;
}

if ( function_exists('opl_is_landing_enabled') && opl_is_landing_enabled() )
	add_action('template_redirect', 'opl_squeeze', 99);

add_action('opl_fb_action', 'opl_widget_facebook_connect');
function opl_widget_facebook_connect() {
	$opl = get_option('opl_settings');
	
	$image = '';
	if ( is_singular() ) {
		global $post;
		
		$meta = get_post_meta($post->ID, 'opl_settings', true);
		if ( opl_isset($meta['enable_opl']) == 1 ) {
			return '';
		}
		
		$url = get_permalink($post->ID);
		$image = opl_facebook_image();
		$title = esc_attr(stripslashes($post->post_title));
		$desc = esc_attr(stripslashes($post->post_content));
		$desc = substr($desc, 0, 160);
	} else {
		$url = get_option('siteurl');
		$title = esc_attr(stripslashes(get_option('blogname')));
		$desc = esc_attr(stripslashes(get_option('blogdesc')));
	}
	
	$title = str_replace(array("\r", "\r\n", "\n"), ' ', $title);
	$desc = str_replace(array("\r", "\r\n", "\n"), ' ', $desc);
?>
jQuery('.opl-wgt-connect').each(function(){
	jQuery(this).click(function(e){
		var $this = jQuery(this);
		var autopost = $this.parent().find('.opl-widget-fb-autopost').val();
		var caption = $this.parent().find('.opl-widget-fb-msg').val();
		$this.parent().parent().find('.opl-btn').hide();
		$this.parent().find('.optin_fb_text').hide();
		$this.hide();
		$this.parent().parent().find('form').append('<div style="text-align:center"><img src="<?php echo OPL_URL; ?>images/loader.gif" border="0" /></div>');
		FB.getLoginStatus(function(response) {
			if ( response.status == 'connected' ) {
				if ( autopost == 1 ) {
					fb_wgt_subscribe(jQuery, $this, caption);
				} else {
					fb_wgt_subscribe_nopost(jQuery, $this);
				}
			} else {
				fb_wgt_login(jQuery, $this, autopost, caption);
			}
		});
		e.preventDefault();
	});
});

function fb_wgt_login($, $this, autopost, caption) {
	FB.login(function(response) {
		if ( response.authResponse ) {
			if ( response.status == 'connected' ) {
				if ( autopost == 1 ) {
					fb_wgt_subscribe(jQuery, $this, caption);
				} else {
					fb_wgt_subscribe_nopost(jQuery, $this);
				}
			}
		}
	}, {scope: 'email,publish_stream'});
}

function fb_wgt_subscribe($, $this, caption) {
	FB.api('/me/feed', 'post', {
		link: '<?php echo $url; ?>',
		picture : '<?php echo $image; ?>',
		name : '<?php echo wptexturize($title); ?>',
		caption : caption,
		description : '<?php echo wptexturize($desc); ?>'
	}, function(response) {
		FB.api('/me', function(response) {
			var opl_name  = response.first_name;
			var opl_email = response.email;
			$this.parent().parent().find('.opl-name').val(opl_name);
			$this.parent().parent().find('.opl-email').val(opl_email);
			var submit_id = $this.parent().parent().parent().find('form').attr('id');
			setTimeout(function(){
				jQuery('form#' + submit_id).submit();
			}, 1000);
		});
	});
}

function fb_wgt_subscribe_nopost($, $this) {
	FB.api('/me', function(response) {
		var opl_name  = response.first_name;
		var opl_email = response.email;
		$this.parent().parent().find('.opl-name').val(opl_name);
		$this.parent().parent().find('.opl-email').val(opl_email);
		var submit_id = $this.parent().parent().parent().find('form').attr('id');
		setTimeout(function(){
			jQuery('form#' + submit_id).submit();
		}, 1000);
	});
}

<?php
}

function ib_plugin_deactivation() {
	wp_clear_scheduled_hook('opl_daily_clean');
}

add_action('init', 'opl_unlock_wgt_viral_bonus');
function opl_unlock_wgt_viral_bonus(){
	if ( opl_isset($_GET['mode']) == 'ib_ajax' && opl_isset($_GET['type']) == 'wgt_viral_download' ) {
		if ( !isset($_POST) )
			return;
	
		$widget_id = $_POST['widget_id'];
		if ( empty($widget_id) ) {
			echo 'failed';
			exit;
		}
		
		$data = get_transient('opl-wgtv-' . $widget_id);
		
		if ( empty($data) || !is_array($data) ) {
			echo 'failed';
			exit;
		}
		
		$url = opl_isset(stripslashes($data['url']));
		$color = opl_isset($data['btn_color']);
		$label = opl_isset(wptexturize(esc_attr(stripslashes($data['btn_label']))));
		
		$body = '<div style="text-align:center">';
		$body .= '<a href="' . $url . '" target="_blank" class="opl-btn btn-' . $color . '"><span>' . $label . '</span></a>';
		$body .= '</div>';
		
		echo $body;
		exit;
	}
}

add_action('opl_fb_action', 'wgt_fb_viral_share');
function wgt_fb_viral_share(){
	if ( is_singular() ) {
		global $post;
		
		$meta = get_post_meta($post->ID, 'opl_settings', true);
		if ( opl_isset($meta['enable_opl']) == 1 ) {
			return '';
		}
	}
	
	$script = '';
	$script .= "
		jQuery('.opl-wgt-fb-lock').each(function(){
			jQuery(this).click(function(e){
				var vdis = jQuery(this);
				var vdata = {
					widget_id: vdis.parent().parent().parent().find('.opl-wgt-viral-id').val(),
					share_url: vdis.parent().parent().parent().find('.opl-wgt-fbs-url').val(),
					title: vdis.parent().parent().parent().find('.opl-wgt-fbs-title').val(),
					desc: vdis.parent().parent().parent().find('.opl-wgt-fbs-desc').val(),
					img: vdis.parent().parent().parent().find('.opl-wgt-fbs-img').val(), 
					holder: vdis.parent().parent().parent().find('.opl-wgt-download-holder')
				};
				FB.getLoginStatus(function(response) {
					if ( response.status == 'connected' ) {
						wgt_fb_viral_share(jQuery, vdata);
					} else {
						wgt_fb_viral_login(jQuery, vdata);
					}
				});
				e.preventDefault();
			});
		});
		
		function wgt_fb_viral_login($, data) {
			FB.login(function(response) {
				if ( response.authResponse ) {
					if ( response.status == 'connected' ) {	
						wgt_fb_viral_share($, data);
					}
				}
			}, {scope: 'email,publish_stream'});
		}

		function wgt_fb_viral_share($, data) {
			FB.api('/me/feed', 'post', {
				link: data.share_url,
				name: data.title,
				picture: data.img,
				caption : '',
				description: data.desc
			}, function(response) {
				data.holder.show();
				var ajaxdata = {
					widget_id: data.widget_id
				};
			
				$.post('" . opl_format_url(get_option('siteurl'), 'mode=ib_ajax&type=wgt_viral_download') . "', ajaxdata, function(response) {
					if ( response != 'failed' ) {
						$.cookie('__opl_wgt_unlock_' + data.widget_id, 1, { expires: 365, path: '" . SITECOOKIEPATH . "' });
						data.holder.html(response);
					} else {
						data.holder.hide();
					}
				});
			});
		}
	";
	
	echo $script;
}