(function() {
	"use strict";
	tinymce.create('tinymce.plugins.instabuilder', {
		init : function(ed, url) {
			ed.addButton( 'instabuilder', {
				type: 'listbox',
				text: 'InstaBuilder',
				icon: false,
				onselect: function(e) {
					
                }, 
                values: [
                	{text: '[-- display videos --]', onclick : function() {
                       // do nothing
                    }},
                    
                    {text: 'MP4 Video', onclick : function() {
                       if ( tinyMCE.activeEditor.selection.getContent() != '' )
								tinyMCE.activeEditor.selection.setContent('[ez_video url="' + tinyMCE.activeEditor.selection.getContent() + '" player="flowplayer" width="640" height="360" autoplay="1" autohide="1" controls="1"]');
							else
								tinyMCE.activeEditor.selection.setContent('[ez_video url="http://" player="flowplayer" width="640" height="360" autoplay="1" autohide="1" controls="1"]');
                    }},
                    
                    {text: 'YouTube', onclick : function() {
                       if ( tinyMCE.activeEditor.selection.getContent() != '' )
								tinyMCE.activeEditor.selection.setContent('[ez_youtube url="' + tinyMCE.activeEditor.selection.getContent() + '" width="640" height="360" autoplay="0" autohide="2" controls="1"]');
							else
								tinyMCE.activeEditor.selection.setContent('[ez_youtube url="http://youtu.be/xxxxxxxx" width="640" height="360" autoplay="0" autohide="2" controls="1"]');
                    }},
                    
                    {text: 'Vimeo', onclick : function() {
                       if ( tinyMCE.activeEditor.selection.getContent() != '' )
								tinyMCE.activeEditor.selection.setContent('[ez_vimeo url="' + tinyMCE.activeEditor.selection.getContent() + '" width="640" height="360" portrait="1" title="1" byline="1" autoplay="0"]');
							else
								tinyMCE.activeEditor.selection.setContent('[ez_vimeo url="http://vimeo.com/xxxxxxx" width="640" height="360" portrait="1" title="1" byline="1" autoplay="0"]');
                    }},
                    
                    {text: '[-- multi columns --]', onclick : function() {
                       // do nothing
                    }},
                    
                    {text: 'Two Columns', onclick : function() {
                       var two_content = ( tinyMCE.activeEditor.selection.getContent() != '' ) ? tinyMCE.activeEditor.selection.getContent() : 'Column 1 content here';
							var col = '';
							col += '[ez_two]<p>' + two_content + '</p>[/ez_two]<br />';
							col += '[ez_two_last]<p>Column 2 content here</p>[/ez_two_last]';
							tinyMCE.activeEditor.selection.setContent(col);
                    }},
                    
                    {text: 'Three Columns', onclick : function() {
                       var three_content = ( tinyMCE.activeEditor.selection.getContent() != '' ) ? tinyMCE.activeEditor.selection.getContent() : 'Column 1 content here';
							var col = '';
							col += '[ez_three]<p>' + three_content + '</p>[/ez_three]<br />';
							col += '[ez_three]<p>Column 2 content here</p>[/ez_three]<br />';
							col += '[ez_three_last]<p>Column 3 content here</p>[/ez_three_last]';
							tinyMCE.activeEditor.selection.setContent(col);
                    }},
                    
                    {text: 'Four Columns', onclick : function() {
                       var four_content = ( tinyMCE.activeEditor.selection.getContent() != '' ) ? tinyMCE.activeEditor.selection.getContent() : 'Column 1 content here';
							var col = '';
							col += '[ez_four]<p>' + four_content + '</p>[/ez_four]<br />';
							col += '[ez_four]<p>Column 2 content here</p>[/ez_four]<br />';
							col += '[ez_four]<p>Column 3 content here</p>[/ez_four]<br />';
							col += '[ez_four_last]<p>Column 4 content here</p>[/ez_four_last]';
							tinyMCE.activeEditor.selection.setContent(col);
                    }},
                    
                    {text: 'Five Columns', onclick : function() {
                       var five_content = ( tinyMCE.activeEditor.selection.getContent() != '' ) ? tinyMCE.activeEditor.selection.getContent() : 'Column 1 content here';
							var col = '';
							col += '[ez_five]<p>' + five_content + '</p>[/ez_five]<br />';
							col += '[ez_five]<p>Column 2 content here</p>[/ez_five]<br />';
							col += '[ez_five]<p>Column 3 content here</p>[/ez_five]<br />';
							col += '[ez_five]<p>Column 4 content here</p>[/ez_five]<br />';
							col += '[ez_five_last]<p>Column 5 content here</p>[/ez_five_last]<br />';
							tinyMCE.activeEditor.selection.setContent(col);
                    }},
                    
                    {text: 'Six Columns', onclick : function() {
                       var six_content = ( tinyMCE.activeEditor.selection.getContent() != '' ) ? tinyMCE.activeEditor.selection.getContent() : 'Column 1 content here';
							var col = '';
							col += '[ez_six]<p>' + six_content + '</p>[/ez_six]<br />';
							col += '[ez_six]<p>Column 2 content here</p>[/ez_six]<br />';
							col += '[ez_six]<p>Column 3 content here</p>[/ez_six]<br />';
							col += '[ez_six]<p>Column 4 content here</p>[/ez_six]<br />';
							col += '[ez_six]<p>Column 5 content here</p>[/ez_six]<br />';
							col += '[ez_six_last]<p>Column 6 content here</p>[/ez_six_last]<br />';
							tinyMCE.activeEditor.selection.setContent(col);
                    }},
                    
                    {text: '1/4 + 3/4 columns', onclick : function() {
                       var three_content = ( tinyMCE.activeEditor.selection.getContent() != '' ) ? tinyMCE.activeEditor.selection.getContent() : 'Column 1 content here';
							var col = '';
							col += '[ez_one_fourth]<p>' + three_content + '</p>[/ez_one_fourth]<br />';
							col += '[ez_three_fourth_last]<p>Column 2 content here</p>[/ez_three_fourth_last]';
							tinyMCE.activeEditor.selection.setContent(col);
                    }},
                    
                    {text: '3/4 + 1/4 columns', onclick : function() {
                       var three_content = ( tinyMCE.activeEditor.selection.getContent() != '' ) ? tinyMCE.activeEditor.selection.getContent() : 'Column 1 content here';
							var col = '';
							col += '[ez_three_fourth]<p>' + three_content + '</p>[/ez_three_fourth]<br />';
							col += '[ez_one_fourth_last]<p>Column 2 content here</p>[/ez_one_fourth_last]';
							tinyMCE.activeEditor.selection.setContent(col);
                    }},
                    
                    {text: '1/3 + 2/3 columns', onclick : function() {
                       var three_content = ( tinyMCE.activeEditor.selection.getContent() != '' ) ? tinyMCE.activeEditor.selection.getContent() : 'Column 1 content here';
							var col = '';
							col += '[ez_one_third]<p>' + three_content + '</p>[/ez_one_third]<br />';
							col += '[ez_two_third_last]<p>Column 2 content here</p>[/ez_two_third_last]';
							tinyMCE.activeEditor.selection.setContent(col);
                    }},
                    
                    {text: '2/3 + 1/3 columns', onclick : function() {
                       var three_content = ( tinyMCE.activeEditor.selection.getContent() != '' ) ? tinyMCE.activeEditor.selection.getContent() : 'Column 1 content here';
							var col = '';
							col += '[ez_two_third]<p>' + three_content + '</p>[/ez_two_third]<br />';
							col += '[ez_one_third_last]<p>Column 2 content here</p>[/ez_one_third_last]';
							tinyMCE.activeEditor.selection.setContent(col);
                    }},
                    
                    {text: '[-- standard buttons --]', onclick : function() {
                       // do nothing
                    }},
                    
                    {text: 'Grey Button', onclick : function() {
                       if ( tinyMCE.activeEditor.selection.getContent() != '' )
								tinyMCE.activeEditor.selection.setContent('[ez_btn color="grey" url="http://" target="_self"]' + tinyMCE.activeEditor.selection.getContent() + '[/ez_btn]');
							else
								tinyMCE.activeEditor.selection.setContent('[ez_btn color="grey" url="http://" target="_self"]Button Label[/ez_btn]');
                    }},
                    
                    {text: 'Red Button', onclick : function() {
                       if ( tinyMCE.activeEditor.selection.getContent() != '' )
								tinyMCE.activeEditor.selection.setContent('[ez_btn color="red" url="http://" target="_self"]' + tinyMCE.activeEditor.selection.getContent() + '[/ez_btn]');
							else
								tinyMCE.activeEditor.selection.setContent('[ez_btn color="red" url="http://" target="_self"]Button Label[/ez_btn]');
                    }},
                    
                    {text: 'Orange Button', onclick : function() {
                       if ( tinyMCE.activeEditor.selection.getContent() != '' )
								tinyMCE.activeEditor.selection.setContent('[ez_btn color="orange" url="http://" target="_self"]' + tinyMCE.activeEditor.selection.getContent() + '[/ez_btn]');
							else
								tinyMCE.activeEditor.selection.setContent('[ez_btn color="orange" url="http://" target="_self"]Button Label[/ez_btn]');
                    }},
                    
                    {text: 'Yellow Button', onclick : function() {
                       if ( tinyMCE.activeEditor.selection.getContent() != '' )
								tinyMCE.activeEditor.selection.setContent('[ez_btn color="yellow" url="http://" target="_self"]' + tinyMCE.activeEditor.selection.getContent() + '[/ez_btn]');
							else
								tinyMCE.activeEditor.selection.setContent('[ez_btn color="yellow" url="http://" target="_self"]Button Label[/ez_btn]');
                    }},
                    
                    {text: 'Green Button', onclick : function() {
                       if ( tinyMCE.activeEditor.selection.getContent() != '' )
								tinyMCE.activeEditor.selection.setContent('[ez_btn color="green" url="http://" target="_self"]' + tinyMCE.activeEditor.selection.getContent() + '[/ez_btn]');
							else
								tinyMCE.activeEditor.selection.setContent('[ez_btn color="green" url="http://" target="_self"]Button Label[/ez_btn]');
                    }},
                    
                    {text: 'Blue Button', onclick : function() {
                       if ( tinyMCE.activeEditor.selection.getContent() != '' )
								tinyMCE.activeEditor.selection.setContent('[ez_btn color="blue" url="http://" target="_self"]' + tinyMCE.activeEditor.selection.getContent() + '[/ez_btn]');
							else
								tinyMCE.activeEditor.selection.setContent('[ez_btn color="blue" url="http://" target="_self"]Button Label[/ez_btn]');
                    }},
                    
                    {text: '[-- big buttons --]', onclick : function() {
                       // do nothing
                    }},
                    
                    {text: 'Big Grey Button', onclick : function() {
                       if ( tinyMCE.activeEditor.selection.getContent() != '' )
								tinyMCE.activeEditor.selection.setContent('[ez_big_btn color="grey" url="http://" target="_self"]' + tinyMCE.activeEditor.selection.getContent() + '[/ez_big_btn]');
							else
								tinyMCE.activeEditor.selection.setContent('[ez_big_btn color="grey" url="http://" target="_self"]Button Label[/ez_big_btn]');
                    }},
                    
                    {text: 'Big Red Button', onclick : function() {
                       if ( tinyMCE.activeEditor.selection.getContent() != '' )
								tinyMCE.activeEditor.selection.setContent('[ez_big_btn color="red" url="http://" target="_self"]' + tinyMCE.activeEditor.selection.getContent() + '[/ez_big_btn]');
							else
								tinyMCE.activeEditor.selection.setContent('[ez_big_btn color="red" url="http://" target="_self"]Button Label[/ez_big_btn]');
                    }},
                    
                    {text: 'Big Orange Button', onclick : function() {
                       if ( tinyMCE.activeEditor.selection.getContent() != '' )
								tinyMCE.activeEditor.selection.setContent('[ez_big_btn color="orange" url="http://" target="_self"]' + tinyMCE.activeEditor.selection.getContent() + '[/ez_big_btn]');
							else
								tinyMCE.activeEditor.selection.setContent('[ez_big_btn color="orange" url="http://" target="_self"]Button Label[/ez_big_btn]');
                    }},
                    
                    {text: 'Big Yellow Button', onclick : function() {
                       if ( tinyMCE.activeEditor.selection.getContent() != '' )
								tinyMCE.activeEditor.selection.setContent('[ez_big_btn color="yellow" url="http://" target="_self"]' + tinyMCE.activeEditor.selection.getContent() + '[/ez_big_btn]');
							else
								tinyMCE.activeEditor.selection.setContent('[ez_big_btn color="yellow" url="http://" target="_self"]Button Label[/ez_big_btn]');
                    }},
                    
                    {text: 'Big Green Button', onclick : function() {
                       if ( tinyMCE.activeEditor.selection.getContent() != '' )
								tinyMCE.activeEditor.selection.setContent('[ez_big_btn color="green" url="http://" target="_self"]' + tinyMCE.activeEditor.selection.getContent() + '[/ez_big_btn]');
							else
								tinyMCE.activeEditor.selection.setContent('[ez_big_btn color="green" url="http://" target="_self"]Button Label[/ez_big_btn]');
                    }},
                    
                    {text: 'Big Blue Button', onclick : function() {
                       if ( tinyMCE.activeEditor.selection.getContent() != '' )
								tinyMCE.activeEditor.selection.setContent('[ez_big_btn color="blue" url="http://" target="_self"]' + tinyMCE.activeEditor.selection.getContent() + '[/ez_big_btn]');
							else
								tinyMCE.activeEditor.selection.setContent('[ez_big_btn color="blue" url="http://" target="_self"]Button Label[/ez_big_btn]');
                    }},
                    
                    {text: '[-- feature boxes --]', onclick : function() {
                       // do nothing
                    }},
                    
                    {text: 'Feature Box - Blue', onclick : function() {
                       var f_content = ( tinyMCE.activeEditor.selection.getContent() != '' ) ? tinyMCE.activeEditor.selection.getContent() : 'Feature box content goes here...';
							var feat = '[ez_box title="Feature Box Title" color="blue"]';
							feat += '<p>' + f_content + '</p>';
							feat += '[/ez_box]';
							tinyMCE.activeEditor.selection.setContent(feat);
                    }},
                    
                    {text: 'Feature Box - Green', onclick : function() {
                       var f_content = ( tinyMCE.activeEditor.selection.getContent() != '' ) ? tinyMCE.activeEditor.selection.getContent() : 'Feature box content goes here...';
							var feat = '[ez_box title="Feature Box Title" color="green"]';
							feat += '<p>' + f_content + '</p>';
							feat += '[/ez_box]';
							tinyMCE.activeEditor.selection.setContent(feat);
                    }},
                    
                    {text: 'Feature Box - Red', onclick : function() {
                       var f_content = ( tinyMCE.activeEditor.selection.getContent() != '' ) ? tinyMCE.activeEditor.selection.getContent() : 'Feature box content goes here...';
							var feat = '[ez_box title="Feature Box Title" color="red"]';
							feat += '<p>' + f_content + '</p>';
							feat += '[/ez_box]';
							tinyMCE.activeEditor.selection.setContent(feat);
                    }},
                    
                    {text: 'Feature Box - Orange', onclick : function() {
                       var f_content = ( tinyMCE.activeEditor.selection.getContent() != '' ) ? tinyMCE.activeEditor.selection.getContent() : 'Feature box content goes here...';
							var feat = '[ez_box title="Feature Box Title" color="orange"]';
							feat += '<p>' + f_content + '</p>';
							feat += '[/ez_box]';
							tinyMCE.activeEditor.selection.setContent(feat);
                    }},
                    
                    {text: 'Feature Box - Grey', onclick : function() {
                       var f_content = ( tinyMCE.activeEditor.selection.getContent() != '' ) ? tinyMCE.activeEditor.selection.getContent() : 'Feature box content goes here...';
							var feat = '[ez_box title="Feature Box Title" color="grey"]';
							feat += '<p>' + f_content + '</p>';
							feat += '[/ez_box]';
							tinyMCE.activeEditor.selection.setContent(feat);
                    }},
                    
                    {text: '[-- popups --]', onclick : function() {
                       // do nothing
                    }},
                    
                    {text: 'PopUp Image', onclick : function() {
                       tinyMCE.activeEditor.selection.setContent('[ez_popup type="image" text="Click Here" thumb_url="Thumbnail image URL here..."]Main Image URL here...[/ez_popup]');
                    }},
                    
                    {text: 'PopUp YouTube Video', onclick : function() {
                       tinyMCE.activeEditor.selection.setContent('[ez_popup type="youtube" text="Click Here To Watch Video" thumb_url="Thumbnail image URL here..." width="640" height="360"]YouTube video URL here...[/ez_popup]');
                    }},
                    
                    {text: 'PopUp Vimeo Video', onclick : function() {
                       tinyMCE.activeEditor.selection.setContent('[ez_popup type="vimeo" text="Click Here To Watch Video" thumb_url="Thumbnail image URL here..." width="640" height="360"]Vimeo video URL here...[/ez_popup]');
                    }},
                    
                    {text: 'PopUp Content', onclick : function() {
                       var pop_content = ( tinyMCE.activeEditor.selection.getContent() != '' ) ? tinyMCE.activeEditor.selection.getContent() : 'Rich content for the popup goes here...';
							var pop = '[ez_popup type="content" text="Click Here" thumb_url="Thumbnail image URL here..." width="600" height="420"]';
							pop += '<p>' + pop_content + '</p>';
							pop += '[/ez_popup]';
							tinyMCE.activeEditor.selection.setContent(pop);
                    }},
                    
                    {text: '[-- misc --]', onclick : function() {
                       // do nothing
                    }},
                    
                    {text: 'Today\'s Date', onclick : function() {
                       tinyMCE.activeEditor.selection.setContent('[ez_date]');
                    }},
                    
                    {text: 'Countdown', onclick : function() {
                       var currentTime = new Date();
							var currentTimezone = currentTime.getTimezoneOffset();
							currentTimezone = (currentTimezone/60) * -1;
							var gmt = 'GMT';
							if ( currentTimezone !== 0 ) {
							  gmt += currentTimezone > 0 ? ' +' : ' ';
							  gmt += currentTimezone;
							}
							var tz = gmt.replace("GMT ", "");
							tinyMCE.activeEditor.selection.setContent('[ez_countdown day="31" month="12" year="2013" hour="0" min="0" sec="0" style="dark" timezone="' + tz + '"]');
                    }},
                    
                    {text: 'Tabbed Content', onclick : function() {
                    	var tab_content = ( tinyMCE.activeEditor.selection.getContent() != '' ) ? tinyMCE.activeEditor.selection.getContent() : 'Tab 1 content here';
							var tabs = '';
							tabs += '[ez_tabs tab1="Tab 1 Title" tab2="Tab 2 Title" tab3="Tab 3 Title" tab4="Tab 4 Title"]<br />';
							tabs += '[ez_tab]<p>' + tab_content + '</p>[/ez_tab]<br />';
							tabs += '[ez_tab]<p>Tab 2 content here</p>[/ez_tab]<br />';
							tabs += '[ez_tab]<p>Tab 3 content here</p>[/ez_tab]<br />';
							tabs += '[ez_tab]<p>Tab 4 content here</p>[/ez_tab]<br />';
							tabs += '[/ez_tabs]';
							tinyMCE.activeEditor.selection.setContent(tabs);
                    }},
                    
                    {text: 'Optin Form', onclick : function() {
                       tinyMCE.activeEditor.selection.setContent('[ez_optin_form]');
                    }},
                    
                    {text: 'Viral Download Lock', onclick : function() {
                       tinyMCE.activeEditor.selection.setContent('[ez_viral_download]');
                    }},
                    
                    {text: 'Facebook Content Reveal', onclick : function() {
                       var fb_content = ( tinyMCE.activeEditor.selection.getContent() != '' ) ? tinyMCE.activeEditor.selection.getContent() : 'Enter the content for your Facebook page fans here';
							
							var fb = '[ez_fb for="non-fans"]<br />';
							fb += '<p>Enter the content for non-fans here</p>';
							fb += '[/ez_fb]<br />';
							fb += '[ez_fb for="fans"]<br />';
							fb += '<p>' + fb_content + '</p>';
							fb += '[/ez_fb]<br />';
                    }},
                ]
         	});
		},
		
		getInfo : function() {
			return {
				longname : "InstaBuilder Shortcodes",
				author : 'Suzanna Theresia',
				authorurl : 'http://instabuilder.com/',
				infourl : 'http://instabuilder.com/',
				version : "1.0"
			};
		}
	});
	tinymce.PluginManager.add('instabuilder', tinymce.plugins.instabuilder);
})();